/*
 * Decompiled with CFR 0.152.
 */
package noppes.npcs;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import noppes.npcs.NBTTags;
import noppes.npcs.NoppesUtilPlayer;
import noppes.npcs.NoppesUtilServer;

public class NpcMiscInventory
implements IInventory {
    public NonNullList<ItemStack> items;
    public int stackLimit = 64;

    public NpcMiscInventory(int size) {
        this.items = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public void addItemStack(ItemStack item) {
        ItemStack mergable;
        while (!(mergable = this.getMergableItem(item)).func_190926_b() && mergable.func_190916_E() > 0) {
            int size = mergable.func_77976_d() - mergable.func_190916_E();
            if (size > item.func_190916_E()) {
                mergable.func_190920_e(mergable.func_77976_d());
                item.func_190920_e(item.func_190916_E() - size);
                continue;
            }
            mergable.func_190920_e(mergable.func_190916_E() + item.func_190916_E());
            item.func_190920_e(0);
        }
        if (item.func_190916_E() <= 0) {
            return;
        }
        int slot = this.firstFreeSlot();
        if (slot >= 0) {
            this.items.set(slot, (Object)item.func_77946_l());
            item.func_190920_e(0);
        }
    }

    public void func_174888_l() {
        this.items.clear();
    }

    public void func_174886_c(@Nonnull EntityPlayer player) {
    }

    @Nonnull
    public ItemStack func_70298_a(int index, int count) {
        return ItemStackHelper.func_188382_a(this.items, (int)index, (int)count);
    }

    public boolean decrStackSize(ItemStack eating, int decrease) {
        for (int slot = 0; slot < this.items.size(); ++slot) {
            ItemStack item = (ItemStack)this.items.get(slot);
            if (item.func_190926_b() || eating != item || item.func_190916_E() < decrease) continue;
            item.func_77979_a(decrease);
            if (item.func_190916_E() <= 0) {
                this.items.set(slot, (Object)ItemStack.field_190927_a);
            }
            return true;
        }
        return false;
    }

    public NpcMiscInventory fill(NpcMiscInventory inv) {
        this.items.clear();
        for (int i = 0; i < this.func_70302_i_() && i < inv.func_70302_i_(); ++i) {
            this.items.set(i, inv.items.get(i));
        }
        return this;
    }

    public int firstFreeSlot() {
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            if (!((ItemStack)this.items.get(i)).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public int getCountEmpty() {
        int c = 0;
        for (int s = 0; s < this.func_70302_i_(); ++s) {
            if (!((ItemStack)this.items.get(s)).func_190926_b()) continue;
            ++c;
        }
        return c;
    }

    @Nonnull
    public ITextComponent func_145748_c_() {
        return new TextComponentString("Custom Inventory");
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public int func_174890_g() {
        return 0;
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public ItemStack getMergableItem(ItemStack item) {
        for (ItemStack is : this.items) {
            if (!NoppesUtilPlayer.compareItems(item, is, false, false) || is.func_190916_E() >= is.func_77976_d()) continue;
            return is;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public String func_70005_c_() {
        return "Npc Misc Inventory";
    }

    public int func_70302_i_() {
        return this.items.size();
    }

    @Nonnull
    public ItemStack func_70301_a(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.field_190927_a;
        }
        return (ItemStack)this.items.get(index);
    }

    public NBTTagCompound save() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74782_a("NpcMiscInv", (NBTBase)NBTTags.nbtItemStackList(this.items));
        compound.func_74768_a("NpcMiscInvSize", this.items.size());
        return compound;
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_191420_l() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            ItemStack item = this.func_70301_a(slot);
            if (NoppesUtilServer.IsItemStackNull(item) || item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean isFull() {
        for (int slot = 0; slot < this.func_70302_i_(); ++slot) {
            if (!this.func_70301_a(slot).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public boolean func_94041_b(int i, @Nonnull ItemStack itemstack) {
        return true;
    }

    public boolean func_70300_a(@Nonnull EntityPlayer var1) {
        return true;
    }

    public void func_70296_d() {
    }

    public void func_174889_b(@Nonnull EntityPlayer player) {
    }

    @Nonnull
    public ItemStack func_70304_b(int slotId) {
        return (ItemStack)this.items.set(slotId, (Object)ItemStack.field_190927_a);
    }

    public void func_174885_b(int id, int value) {
    }

    public void load(NBTTagCompound compound) {
        NBTTags.getItemStackList(compound.func_150295_c("NpcMiscInv", 10), this.items);
    }

    public void func_70299_a(int slotId, @Nonnull ItemStack stack) {
        if (slotId >= this.func_70302_i_()) {
            return;
        }
        this.items.set(slotId, (Object)stack);
    }

    public void setSize(int size) {
        if (this.items.size() == size) {
            return;
        }
        NonNullList newItems = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
        for (int slot = 0; slot < this.items.size() && slot < size; ++slot) {
            if (((ItemStack)this.items.get(slot)).func_190926_b()) continue;
            newItems.set(slot, this.items.get(slot));
        }
        this.items = newItems;
    }

    public boolean remove(int slotID) {
        if (slotID < 0 || slotID >= this.items.size()) {
            return false;
        }
        NonNullList newItems = NonNullList.func_191197_a((int)(this.items.size() - 1), (Object)ItemStack.field_190927_a);
        for (int slot = 0; slot < this.items.size(); ++slot) {
            if (((ItemStack)this.items.get(slot)).func_190926_b() || slotID == slot) continue;
            newItems.set(slot - (slot > slotID ? 1 : 0), this.items.get(slot));
        }
        this.items = newItems;
        return true;
    }
}

